# -*- coding: utf-8 -*-
"""
Created on Sat Jul  6 12:04:25 2019

@author: tooba
"""
import itertools
import numpy as np
import pandas as pd
import socket
import struct
import datetime
from sklearn.model_selection import train_test_split
from numpy import array
from numpy import argmax
from keras.utils import to_categorical
from keras.models import Sequential
from keras.layers import LSTM
from keras.layers import Dense, Activation
from sklearn.metrics import accuracy_score
from sklearn.datasets import load_iris
from sklearn import preprocessing
from keras.layers import Dense, Dropout, Flatten, Embedding
import matplotlib.pyplot as plt
from sklearn.metrics import  classification_report
from mlxtend.evaluate import confusion_matrix
from sklearn.preprocessing import StandardScaler
import matplotlib.pyplot as plt
from itertools import cycle
from sklearn.metrics import roc_auc_score

from sklearn import svm, datasets
from sklearn.metrics import roc_curve, auc
from sklearn.preprocessing import label_binarize
from sklearn.multiclass import OneVsRestClassifier
from scipy import interp

#Confusion Matrix
def plot_confusion_matrix(cm, classes,
                          normalize=False,
                          title='Confusion matrix',
                          cmap=plt.cm.Greens):
    """
    This function prints and plots the confusion matrix.
    Normalization can be applied by setting `normalize=True`.
    """
    if normalize:
        cm = cm.astype('float') / cm.sum(axis=1)[:, np.newaxis]
        print("Normalized confusion matrix")
    else:
        print('Confusion matrix, without normalization')

    print(cm)
    
    plt.figure(figsize=(5,5))
    plt.imshow(cm, interpolation='nearest', cmap=cmap)    
    plt.title(title)
    plt.colorbar()
    tick_marks = np.arange(len(classes))
    plt.xticks(tick_marks, classes, rotation=45)
    plt.yticks(tick_marks, classes)

    fmt = '.2f' if normalize else 'd'
    thresh = cm.max() / 2.
    for i, j in itertools.product(range(cm.shape[0]), range(cm.shape[1])):
        plt.text(j, i, format(cm[i, j], fmt),
                 horizontalalignment="center",
                 color="white" if cm[i, j] > thresh else "black")

    plt.tight_layout()
    plt.ylabel('True label')
    plt.xlabel('Predicted label')
    plt.savefig('Testplot.jpeg')


#import training data
dynamic_classes = 3
dataset = pd.read_csv('Book1.csv')
dataset = dataset.sample(frac=1).reset_index(drop=True)


#split dataset
X = dataset.iloc[:,:115]
Y = dataset.iloc[:,116:117]

#from sklearn import preprocessing

min_max_scaler = preprocessing.MinMaxScaler()
X = min_max_scaler.fit_transform(X)


#Slicing
x_train, x_test, y_train, y_test = train_test_split (X,Y, test_size=0.2)


#OHE
y_train = to_categorical(y_train, dynamic_classes)
y_train= pd.DataFrame(y_train)

x_train = np.array(x_train)
x_test = np.array(x_test)
x_train = np.reshape(x_train, (x_train.shape[0], 1, x_train.shape[1]))
x_test = np.reshape(x_test, (x_test.shape[0], 1,  x_test.shape[1])) 

model = Sequential()
model.add(LSTM(100, activation='relu', input_shape = (x_train.shape[1],x_train.shape[2]), return_sequences=True)) 
model.add(LSTM(350, activation='relu', return_sequences=True))
model.add(Dropout(0.2))
model.add(LSTM(300, return_sequences=True, activation='relu'))
model.add(LSTM(125, return_sequences=True, activation='softmax'))
model.add(LSTM(50, return_sequences=False, activation='relu'))
model.add(Dense(16, activation='relu')) 
model.add(Dense(16, activation='relu')) 
model.add(Dense(16, activation='relu')) 
model.add(Dense(dynamic_classes, activation='softmax'))
model.summary()
model.compile(loss='categorical_crossentropy', optimizer='adam', metrics=['accuracy'])
 

#Fiting Model
t1 = datetime.datetime.now()
score = model.fit(x_train, y_train, batch_size = 4, epochs = 30)
t2 = datetime.datetime.now()
print('Total time for traning: {}'.format(t2-t1))

#pred_LSTM
predictions = model.predict(x_test)
predictions = np.round(predictions)
predictions = np.array(predictions)
#Invering OHE
predictions = predictions.argmax(1)
predictions = to_categorical (predictions, dynamic_classes)
predictions = pd.DataFrame(predictions)
y_test = np.array(y_test)
y_test = y_test.argmax(1)
y_test = pd.DataFrame(y_test)
#Accuracy
print ("Accuracy:  ", accuracy_score(y_test,predictions)*100)

#Classificaiton report
print("Classification Report")
print(classification_report(y_test,predictions))

#Confusion Matrix
                                     
#Calculating Confusion Matix for 3D
class_names = ['Benign','Mirari','Gafgyt']
cm = confusion_matrix(y_test,predictions, binary=False)
plt.figure()
plot_confusion_matrix(cm, classes=class_names , normalize=False,
                      title='Confusion matrix, without normalization')


#TP FP
#FN TN
print(cm_cnn)
cm_cnn = np.array(cm_cnn)
TP = cm_cnn[0][0]
#FP = np.int(np.sum(cm_cnn[np.triu_indices(num_classes,1,num_classes)]))
FP =  np.triu(cm_cnn).sum()-np.trace(cm_cnn)
# cm[row][column]
FN = np.tril(cm_cnn).sum()-np.trace(cm_cnn)
print()
TN = np.trace(cm_cnn) - TP



#Calculating Other Parameters
print('TP:{}'.format(TP))
print('FP:{}'.format(FP))
print('FN:{}'.format(FN))
print('TN:{}'.format(TN))
print('TPR: {}'.format(TP/(TP + FN)))
print('TNR: {}'.format(TN/(TN + FP)))
print('PPV: {}'.format(TP/(TP + FP)))
print('NPV: {}'.format(TN/(TN + FN)))
print('FNR: {}'.format(FN/(FN + TP)))
print('FPR: {}'.format(FP/(FP + TN)))
print('FDR: {}'.format(FP/(FP + TP)))
print('FOR: {}'.format(FN/(FN + TN)))

TP
from sklearn.metrics import matthews_corrcoef
MCC = matthews_corrcoef(y_test, pred_cnn) 
print('MCC: {}'.format(MCC))

#ROC
y_test = label_binarize(y_test, classes=[0, 1, 2])
n_classes = y_test.shape[1]
# Compute macro-average ROC curve and ROC area
# Compute ROC curve and ROC area for each class
fpr = dict()
tpr = dict()
roc_auc = dict()
for i in range(n_classes):
    fpr[i], tpr[i], _ = roc_curve(y_test[:, i], predictions[:, i])
    roc_auc[i] = auc(fpr[i], tpr[i])

# Compute micro-average ROC curve and ROC area
fpr["micro"], tpr["micro"], _ = roc_curve(y_test.ravel(), predictions.ravel())
roc_auc["micro"] = auc(fpr["micro"], tpr["micro"])
plt.figure()

lw = 2
plt.plot(fpr[2], tpr[2], color='darkorange',
         lw=lw, label='ROC curve (area = %0.2f)' % roc_auc[2])
plt.plot([0, 1], [0, 1], color='navy', lw=lw, linestyle='--')
plt.xlim([0.0, 1.0])
plt.ylim([0.0, 1.05])
plt.xlabel('False Positive Rate')
plt.ylabel('True Positive Rate')
plt.title('Receiver operating characteristic example')
plt.legend(loc="lower right")
plt.show()
# First aggregate all false positive rates
all_fpr = np.unique(np.concatenate([fpr[i] for i in range(n_classes)]))

# Then interpolate all ROC curves at this points
mean_tpr = np.zeros_like(all_fpr)
for i in range(n_classes):
    mean_tpr += interp(all_fpr, fpr[i], tpr[i])

# Finally average it and compute AUC
mean_tpr /= n_classes

fpr["macro"] = all_fpr
tpr["macro"] = mean_tpr
roc_auc["macro"] = auc(fpr["macro"], tpr["macro"])

# Plot all ROC curves
plt.figure()
plt.plot(fpr["micro"], tpr["micro"],
         label='micro-average ROC curve (area = {0:0.2f})'
               ''.format(roc_auc["micro"]),
         color='deeppink', linestyle=':', linewidth=4)

plt.plot(fpr["macro"], tpr["macro"],
         label='macro-average ROC curve (area = {0:0.2f})'
               ''.format(roc_auc["macro"]),
         color='navy', linestyle=':', linewidth=4)

colors = cycle(['aqua', 'darkorange', 'cornflowerblue'])
for i, color in zip(range(n_classes), colors):
    plt.plot(fpr[i], tpr[i], color=color, lw=lw,
             label='ROC curve of class {0} (area = {1:0.2f})'
             ''.format(i, roc_auc[i]))

plt.plot([0, 1], [0, 1], 'k--', lw=lw)
plt.xlim([0.0, 1.0])
plt.ylim([0.0, 1.05])
plt.xlabel('False Positive Rate')
plt.ylabel('True Positive Rate')
plt.title('Some extension of Receiver operating characteristic to multi-class')
plt.legend(loc="lower right")
plt.show()
